#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Woven Rectangle Tree TruchetMod01.fsh  by  chronos     
//https://www.shadertoy.com/view/M3fyzM
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*

    "Woven Rectangle Tree Truchet" by chronos
    ----------------------------------------------------------------------------------
    
    Hacked together a simple weave crossover pattern to use instead of parallel lines
    in the base layer, and made the disc pattern transparent.
    
    Unfortunately there are still a lot of defects, because of how I hacked together the
    pattern (   and the code is messy and suboptimal as well. Sorry Fabrice... :|   )
    
    
    Self link https://www.shadertoy.com/view/M3fyzM
    
    ----------------------------------------------------------------------------------
    Forked shader description:
    ----------------------------------------------------------------------------------
        "Variant of "RectSubdivide Multiscale Truchet" by SnoopethDuckDuck" by chronos

        Tried to code this pattern myself after learning from the original shader.
        It's not as good as Snoopeth's, but close enough for me! ¯\_(ツ)_/¯

        See SnoopethDuckDuck's original shader here: https://www.shadertoy.com/view/XfSBWV
    
    ----------------------------------------------------------------------------------
*/

#define TRANSPARENT_DISCS 1
#define ALLOW_MIDDLE_DISCS 0
#define POLAR_COORDINATES 1
#define TUNNEL_COORDINATES 0
#define CAST_SHADOW 0
#define USE_WEAVE 1

const float gridsize = 10.;
const int num_iterations = 3;
float zoom = 2.;
    
    
vec2 split_wh(vec2 uv, vec2 wh, vec2 p)
{
    wh.x = uv.x < p.x ? p.x : wh.x - p.x;
    wh.y = uv.y < p.y ? p.y : wh.y - p.y;
    return wh;
}

vec2 split_uv(vec2 uv, vec2 p)
{
    uv.x = uv.x < p.x ? uv.x : uv.x - p.x;
    uv.y = uv.y < p.y ? uv.y : uv.y - p.y;
    return uv;
}

vec2 split_id(vec2 uv, vec2 p)
{
    uv.x = uv.x < p.x ? 0. : 1.;
    uv.y = uv.y < p.y ? 0. : 1.;
    return uv;
}

vec3 id_to_color(vec2 ids)
{
    return pow(texelFetch(texture0, ivec2(ids)%1024, 0).rgb, vec3(2.));
}

int ids_to_id(vec2 ids, int iter)
{
    ivec2 IDs = ivec2(ids);
    int id = (IDs.y << iter) + IDs.x;
    return id;
}

ivec4 permutation(int id)
{
    ivec4 perm = ivec4(0,1,2,3);
    
    ivec4[24] all_permutations = ivec4[](
        perm.xyzw,
        perm.xywz,
        perm.xzyw,
        perm.xzwy,
        perm.xwyz,
        perm.xwzy,

        perm.yxzw,
        perm.yxwz,
        perm.yzxw,
        perm.yzwx,
        perm.ywxz,
        perm.ywzx,

        perm.zyxw,
        perm.zywx,
        perm.zxyw,
        perm.zxwy,
        perm.zwyx,
        perm.zwxy,

        perm.wyzx,
        perm.wyxz,
        perm.wzyx,
        perm.wzxy,
        perm.wxyz,
        perm.wxzy
    );
    
    return all_permutations[id%24];
}

vec3 weave_pattern(vec2 uv, float ps)
{
    float sgn = 1. - 2. * abs(float((int(floor(uv.x)) % 2)));
    uv.y = sgn * uv.y;
    uv.x = abs(uv.x);

    float r = 2./3.;

    float f =
        smoothstep((1.-r)-ps, (1.-r)+ps, uv.x) *
        smoothstep(r+ps, r-ps, uv.x) *
        step(.5, abs(uv.y))
    ;

    vec3 color = vec3(f);

    vec2 p = vec2(.0, -.5);
    float d = length(uv - p) - r;
    float a = smoothstep(ps, -ps, d) * step(p.x, uv.x) * step(p.y, uv.y) * smoothstep(-r*.5 - ps, -r*.5 + ps, d);
    
    float pattern = 
            smoothstep(1./3.-ps, 1./3.+ps, fract(d+.66)) * 
            smoothstep(2./3.+ps, 2./3.-ps, fract(d+.66));
    
    color = mix(color, vec3(pattern), a);

    // Shadow
    p = vec2(.0, .5);
    d = length(uv - p) - r;
    
    pattern = 
            smoothstep(1./3.-ps, 1./3.+ps, fract(d+2./3.)) * 
            smoothstep(2./3.+ps, 2./3.-ps, fract(d+2./3.));
    
    a = smoothstep(0.1+ps, 0., d) * step(p.x, uv.x) * step(uv.y, p.y) * smoothstep(-r*.5 - ps, -r*.5 + ps, d);
    color *= 1.-a;

    a = smoothstep(ps, -ps, d) * step(p.x, uv.x) * step(uv.y, p.y) * smoothstep(-r*.5 - ps, -r*.5 + ps, d);
    color = mix(color, vec3(pattern), a);
    
    return color;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (2. * fragCoord - iResolution.xy) / iResolution.y;
    
    zoom = zoom * (max(cos(iTime*.5), 0.)+1.);
    
    float t = -iTime*.05;
    
    #if POLAR_COORDINATES
        #if TUNNEL_COORDINATES
            uv *= zoom;
            uv = vec2(3./(length(uv)), 6.*fract(t*.5 + .5*(1.+atan(uv.y, uv.x)/3.14159265)));
            float ps = //(uv.y < 5.99 && uv.y > 0.01) || uv.x > 6. ? length(fwidth(uv))/2. : 
                exp(2.*min(uv.x/2., 5.)) / iResolution.y;
            uv.x += iTime*.5;
            vec2 UV = uv;
        #else
            float len = length(uv);
            uv = vec2(log(len)*.75, 6.*fract(t*.5 + .5*(1.+atan(uv.y, uv.x)/3.14159265)));
            float ps = 2./(len * iResolution.y); //length(fwidth(uv))/2.;
            vec2 UV = uv;
            uv.x += iTime*.5;
            uv.x = fract(uv.x);
        #endif
    
    #else
        uv *= zoom;
        float ps = zoom / iResolution.y;
        uv = (uv + 1.) / 2.;
        uv += vec2(cos(t), sin(t))*10.;
        vec2 UV = uv;
    #endif
    
    vec3 color = vec3(0);

    vec2 p   = vec2(0);
    vec2 ids = floor(uv+1024.);
    
    uv = fract(uv+1024.);
    
    vec2 wh = vec2(1);
    for(int i = 0; i < num_iterations; i++)
    {
        p   = ((1./gridsize) + (1.-2./gridsize) * texelFetch(texture0, ivec2(ids)%1024, 0).rg) * wh;
        
        p = round(gridsize * p) / gridsize;
                
        ids = ids * 2. + split_id(uv, p);
        wh  = split_wh(uv, wh, p);
        uv  = split_uv(uv, p);
  
        if(min(wh.x, wh.y) <= 2./gridsize) break;
    }

    color += 
        smoothstep(1./3.-gridsize*ps, 1./3.+gridsize*ps, fract(gridsize * (wh.x < wh.y? uv.y : uv.x))) * 
        smoothstep(2./3.+gridsize*ps, 2./3.-gridsize*ps, fract(gridsize * (wh.x < wh.y? uv.y : uv.x)));
    #if USE_WEAVE
    if(min(wh.x, wh.y) >= 2./gridsize)
    {
        vec2 weave_uv = uv ;
        weave_uv = fract(.5 * gridsize * ((wh.x < wh.y? weave_uv.yx : weave_uv.xy)- vec2(0., -.5/gridsize))) *2. - 1.;
        color = weave_pattern(weave_uv, gridsize*ps);
    }
    #endif
        

    vec2[4] positions = vec2[]( vec2(0), vec2(1,0)*wh, vec2(0,1)*wh, wh );

    float r = min(wh.x, wh.y);
    int id = ids_to_id(ids, num_iterations);
    
    // This allows some of the rectangles to put their discs on the middle of the short edges,
    // instead of the coners
    #if ALLOW_MIDDLE_DISCS
    
        if(id % 3 == 0)
        {
            r/=2.;
            if(wh.x < wh.y)
            {
                positions[0] = vec2(r, 0);
                positions[1] = vec2(r, 0);
                positions[2] = vec2(r, wh.y);
                positions[3] = vec2(r, wh.y);
            }
            else
            {
                positions[0] = vec2(0, r);
                positions[1] = vec2(wh.x, r);
                positions[2] = vec2(0, r);
                positions[3] = vec2(wh.x, r);
            }
        }   
    
    #endif

    ivec4 perm = permutation(id);
    
    for(int i = 0; i < 4; i++)
    {
        vec2 pos = positions[perm[i]];
        
        float d = length(uv - pos) - r;
        
        //float trim = .125/gridsize; // trims half the black edge
        //float trim = .25/gridsize;  // trims the entire black edge
        float trim = .175/gridsize;   // trims the majority of the black edge
        
        float pattern = 
            smoothstep(1./3.-gridsize*ps, 1./3.+gridsize*ps, fract(gridsize * d)) * 
            smoothstep(2./3.+gridsize*ps, 2./3.-gridsize*ps, fract(gridsize * d));

        #if TRANSPARENT_DISCS
        // Cast shadow from white lines
        color *= 
            mix(1.-
                smoothstep(0.3 -gridsize*ps, 1./3.+gridsize*ps, fract(gridsize * d)) * 
                smoothstep(0.9+gridsize*ps, 2./3.-gridsize*ps, fract(gridsize * d)),
            1.,
            smoothstep(0., trim, d+trim))
            ;
            
        color = mix(color, vec3(1), pattern * smoothstep(ps, -ps, d + trim)); // only draw white lines
        
        #else
        
            #if CAST_SHADOW && !POLAR_COORDINATES
                color *= smoothstep(0., trim, d+trim); // disc shadow
            #endif
        color = mix(color, vec3(pattern), smoothstep(ps, -ps, d + trim)); // draw pattern on disc
        #endif
    }

    if(iMouse.z > 0.)
    {
    
        color = mix(color, vec3(1), smoothstep(wh.x-0.005-ps, wh.x-0.005, uv.x));
        color = mix(color, vec3(1), smoothstep(wh.y-0.005-ps, wh.y-0.005, uv.y));
        
        color = mix(color, vec3(1), smoothstep(0.005+ps, 0.005, uv.x));
        color = mix(color, vec3(1), smoothstep(0.005+ps, 0.005, uv.y));
        
        color = color*.8 +.2;
        color *= id_to_color(ids);
    }
    
    #if POLAR_COORDINATES && !TUNNEL_COORDINATES
    
    color *= pow(tanh(len*2.), 1.);
    
    #endif
    
    color = pow(clamp(color, 0., 1.), vec3(1./2.2));
    fragColor = vec4(color, 1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

